//
//  SUAppcast.h
//  Sparkle
//
//  Created by Andy Matuschak on 3/12/06.
//  Copyright 2006 Andy Matuschak. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class RSS, SUAppcastItem;
@interface SUAppcast : NSObject {
	NSArray *items;
	id delegate;
}

- (void)fetchAppcastFromURL:(NSURL *)url;
- (void)setDelegate:delegate;

- (SUAppcastItem *)newestItem;
- (NSArray *)items;

@end

@interface NSObject (SUAppcastDelegate)
- (void)appcastDidFinishLoading:(SUAppcast *)appcast;	// TLJF 17-Sep-2009 Add missing return value to prototype
- (void)appcastDidFailToLoad:(SUAppcast *)appcast;		// TLJF 17-Sep-2009 Add missing return value to prototype

@end